from RPiKeyboardConfig import RPiKeyboardConfig
import time

# Initialise the keyboard
keyboard = RPiKeyboardConfig()

# Set LED direct control mode
keyboard.set_led_direct_effect()


while True:
    # Set individual LED by index (HSV format: hue, saturation, value)
    keyboard.set_led_by_idx(idx=33, colour=(20, 255, 255))      # orange
    # Send LED updates to keyboard (required after setting colours)
    keyboard.send_leds()
    time.sleep(0.5)
    
    # Set LED by matrix position
    keyboard.set_led_by_matrix(matrix=[2, 3], colour=(180, 255, 255))  # purple
    # Send LED updates to keyboard (required after setting colours)
    keyboard.send_leds()
    time.sleep(0.5)

    print(keyboard.get_leds())
    
    
    